
PrefabFiles = {
	"kurumi",
	"kurumi_gun",
	"kurumi_self",
	"kurumi_kekedi",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/kurumi.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/kurumi.xml" ),

    Asset( "IMAGE", "bigportraits/kurumi.tex" ),
    Asset( "ATLAS", "bigportraits/kurumi.xml" ),
	
	Asset( "IMAGE", "images/map_icons/kurumi.tex" ),
	Asset( "ATLAS", "images/map_icons/kurumi.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_kurumi.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_kurumi.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_kurumi.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_kurumi.xml" ),

}

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS

-- The character select screen lines
STRINGS.CHARACTER_TITLES.kurumi = "kurumi (狂三)"
STRINGS.CHARACTER_NAMES.kurumi = "kurumi"
STRINGS.CHARACTER_DESCRIPTIONS.kurumi = "*Perk 1\n*Perk 2\n*Perk 3"
STRINGS.CHARACTER_QUOTES.kurumi = "\"Quote\""

-- Custom speech strings
STRINGS.CHARACTERS.KURUMI = require "speech_kurumi"

-- The character's name as appears in-game 
STRINGS.NAMES.KURUMI = "kurumi"

-- The default responses of examining the character
STRINGS.CHARACTERS.GENERIC.DESCRIBE.KURUMI = 
{
	GENERIC = "It's kurumi!",
	ATTACKER = "That kurumi looks shifty...",
	MURDERER = "Murderer!",
	REVIVER = "kurumi, friend of ghosts.",
	GHOST = "kurumi could use a heart.",
}


AddMinimapAtlas("images/map_icons/kurumi.xml")

-- Add mod character to mod character list. Also specify a gender. Possible genders are MALE, FEMALE, ROBOT, NEUTRAL, and PLURAL.
AddModCharacter("kurumi", "FEMALE")

--制作栏
local kurumitab = AddRecipeTab("Kurumi", 1041, "images/kurumitab.xml", "kurumitab.tex", "kurumi")
--枪
local kurumi_gun = AddRecipe("kurumi_gun",
{GLOBAL.Ingredient("nightmarefuel", 2), GLOBAL.Ingredient("purplegem", 1)}, 
kurumitab, GLOBAL.TECH.NONE,
nil, nil, nil, nil, "kurumi",
"images/kurumi_gun.xml", "kurumi_gun.tex")
STRINGS.NAMES.KURUMI_GUN = "狂三的水枪"
STRINGS.RECIPE_DESC.KURUMI_GUN = "狂三的水枪"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.KURUMI_GUN = "狂三的水枪"

--UI
local kurumi_timepiont = require("widgets/kurumi_timepiont")
local function Add(self) 
	if self.owner and self.owner:HasTag("kurumi") then
		self.kurumi_timepiont = self.status:AddChild(kurumi_timepiont(self.owner))	
		self.kurumi_timepiont:SetPosition(-80,-40,0)	
		self.kurumi_timepiont:SetScale(1,1,1)	
	end
end

AddClassPostConstruct("widgets/controls", Add)


--不被梦魇视为目标
AddComponentPostInit("combat", function(self)

	local old_CanTarget = self.CanTarget
	function self:CanTarget(target)
		if self.inst:HasTag("shadowcreature") and target:HasTag("kurumi") then
			return false
		else
			return old_CanTarget(self, target)
		end
	end

end)












